﻿using System.Collections.Generic;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public class PatientImageDetailManager 
    {
        private readonly object Locker;
        private readonly PatientImageDetailDB DetailDB;
        private readonly PATIENT_IMAGE_REVIEWDB ReviewDB;

        public PatientImageDetailManager()
        {
            this.Locker = new object();
            this.DetailDB = new PatientImageDetailDB();
            this.ReviewDB = new PATIENT_IMAGE_REVIEWDB();
        }

        public int InsertUpdatePatientImageReview(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            PATIENT_IMAGE_REVIEW objSave,
            IReadOnlyList<int> imageBodyParts,
            IReadOnlyList<int> imagingReasons)
        {
            lock (this.Locker)
            {
                int result = 0;

                result = this.ReviewDB.InsertUpdatePatientImageReview(
                    CURRENT_USER, CURRENT_REGISTRY_ID, objSave, imageBodyParts, imagingReasons);

                return result;
            }
        }

        public PatientImageDetail GetPatientImageDetails(string CURRENT_USER, int CURRENT_REGISTRY_ID, int patientImageId)
        {
            return this.DetailDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, patientImageId);
        }
    }
}
